/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.messagebox.model;

import org.jupnp.support.messagebox.model.DateTime;
import org.jupnp.support.messagebox.model.Message;
import org.jupnp.support.messagebox.model.NumberName;
import org.jupnp.support.messagebox.parser.MessageElement;

public class MessageSMS
extends Message {
    private final DateTime receiveTime;
    private final NumberName receiver;
    private final NumberName sender;
    private final String body;

    public MessageSMS(NumberName receiver, NumberName sender, String body) {
        this(new DateTime(), receiver, sender, body);
    }

    public MessageSMS(DateTime receiveTime, NumberName receiver, NumberName sender, String body) {
        this(Message.DisplayType.MAXIMUM, receiveTime, receiver, sender, body);
    }

    public MessageSMS(Message.DisplayType displayType, DateTime receiveTime, NumberName receiver, NumberName sender, String body) {
        super(Message.Category.SMS, displayType);
        this.receiveTime = receiveTime;
        this.receiver = receiver;
        this.sender = sender;
        this.body = body;
    }

    public DateTime getReceiveTime() {
        return this.receiveTime;
    }

    public NumberName getReceiver() {
        return this.receiver;
    }

    public NumberName getSender() {
        return this.sender;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public void appendMessageElements(MessageElement parent) {
        this.getReceiveTime().appendMessageElements((MessageElement)parent.createChild("ReceiveTime"));
        this.getReceiver().appendMessageElements((MessageElement)parent.createChild("Receiver"));
        this.getSender().appendMessageElements((MessageElement)parent.createChild("Sender"));
        ((MessageElement)parent.createChild("Body")).setContent(this.getBody());
    }
}

