/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ExportTemplate;
import org.tinymediamanager.core.MediaEntityExporter;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.textfield.LinkTextArea;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPaneHTML;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public abstract class ExporterPanel
extends AbstractModalInputPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExporterPanel.class);
    protected final JTextField tfExportDir;
    protected final JList<ExportTemplate> list;
    protected final String panelId;

    public ExporterPanel(MediaEntityExporter.TemplateType type) {
        BasicEventList templatesFound = new BasicEventList();
        this.panelId = type.name() + ".exporter";
        this.setLayout((LayoutManager)new MigLayout("", "[800lp,grow]", "[450lp,grow][]"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setName(this.panelId + ".splitPane");
        TmmUILayoutStore.getInstance().install(splitPane);
        splitPane.setResizeWeight(0.7);
        this.add((Component)splitPane, "cell 0 0,grow");
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setLeftComponent(scrollPane);
        this.list = new JList();
        scrollPane.setViewportView(this.list);
        JPanel panelExporterDetails = new JPanel();
        splitPane.setRightComponent(panelExporterDetails);
        panelExporterDetails.setLayout((LayoutManager)new MigLayout("", "[100lp,grow]", "[][][][200lp,grow][]"));
        JLabel lblTemplateName = new JLabel("");
        TmmFontHelper.changeFont((JComponent)lblTemplateName, 1.33333);
        panelExporterDetails.add((Component)lblTemplateName, "cell 0 0,growx");
        JLabel lblUrl = new JLabel("");
        panelExporterDetails.add((Component)lblUrl, "cell 0 1,growx");
        JCheckBox chckbxTemplateWithDetail = new JCheckBox("");
        chckbxTemplateWithDetail.setEnabled(false);
        panelExporterDetails.add((Component)chckbxTemplateWithDetail, "flowx,cell 0 2");
        NoBorderScrollPane scrollPaneDescription = new NoBorderScrollPane();
        panelExporterDetails.add((Component)scrollPaneDescription, "cell 0 3,grow");
        ReadOnlyTextPaneHTML taDescription = new ReadOnlyTextPaneHTML();
        scrollPaneDescription.setViewportView(taDescription);
        TmmLabel lblDetails = new TmmLabel(TmmResourceBundle.getString("export.detail"));
        panelExporterDetails.add((Component)lblDetails, "cell 0 2,growx,aligny center");
        LinkTextArea taSource = new LinkTextArea();
        panelExporterDetails.add((Component)taSource, "cell 0 4,growx");
        taSource.addActionListener(arg0 -> {
            if (!StringUtils.isEmpty((CharSequence)taSource.getText())) {
                Path path = Paths.get(taSource.getText(), new String[0]);
                TmmUIHelper.openFolder(path);
            }
        });
        splitPane.setDividerLocation(300);
        this.tfExportDir = new JTextField(TmmProperties.getInstance().getProperty(this.panelId + ".path"));
        this.add((Component)this.tfExportDir, "flowx,cell 0 1,growx");
        this.tfExportDir.setColumns(10);
        JButton btnSetDestination = new JButton(TmmResourceBundle.getString("export.setdestination"));
        this.add((Component)btnSetDestination, "cell 0 1");
        btnSetDestination.addActionListener(e -> {
            Path file = TmmUIHelper.selectDirectory(TmmResourceBundle.getString("export.selectdirectory"), this.tfExportDir.getText());
            if (file != null) {
                this.tfExportDir.setText(file.toAbsolutePath().toString());
                TmmProperties.getInstance().putProperty(this.panelId + ".path", this.tfExportDir.getText());
            }
        });
        this.btnClose.setText(TmmResourceBundle.getString("Toolbar.export"));
        templatesFound.addAll(MediaEntityExporter.findTemplates(type));
        this.list.setModel((ListModel<ExportTemplate>)new DefaultEventListModel((EventList)templatesFound));
        String lastTemplateName = TmmProperties.getInstance().getProperty(this.panelId + ".template");
        if (StringUtils.isNotBlank((CharSequence)lastTemplateName)) {
            this.list.setSelectedValue(lastTemplateName, true);
        }
        this.list.addListSelectionListener(e -> {
            ExportTemplate exportTemplate = this.list.getSelectedValue();
            if (exportTemplate == null) {
                lblTemplateName.setText("");
                lblDetails.setText("");
                taDescription.setText("");
                lblUrl.setText("");
                chckbxTemplateWithDetail.setSelected(false);
                taSource.setText("");
            } else {
                lblTemplateName.setText(exportTemplate.getName());
                taDescription.setText(exportTemplate.getDescription());
                lblUrl.setText(exportTemplate.getUrl());
                chckbxTemplateWithDetail.setSelected(exportTemplate.isDetail());
                taSource.setText(exportTemplate.getPath());
            }
        });
    }

    protected Path getExportPath() throws IOException {
        Path exportPath = Paths.get(this.tfExportDir.getText(), new String[0]);
        if (!Files.exists(exportPath, new LinkOption[0])) {
            JOptionPane.showMessageDialog(this, TmmResourceBundle.getString("export.foldernotfound"));
            throw new FileNotFoundException();
        }
        if (!Utils.isFolderEmpty(exportPath)) {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int decision = JOptionPane.showOptionDialog(this, TmmResourceBundle.getString("export.foldernotempty"), "", 0, 3, null, options, null);
            if (decision == 1) {
                throw new FileAlreadyExistsException(exportPath.toString());
            }
        }
        return exportPath;
    }
}

