/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Toolkit;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.tinymediamanager.core.TmmResourceBundle;

public class TextFieldPopupMenu {
    private static JMenuItem getCutMenuItem(JPopupMenu menu) {
        JMenuItem mntmCut = new JMenuItem(TmmResourceBundle.getString("menuitem.cut"));
        mntmCut.addActionListener(e -> {
            if (menu.getInvoker() instanceof JTextComponent) {
                ((JTextComponent)menu.getInvoker()).cut();
            }
        });
        return mntmCut;
    }

    private static JMenuItem getCopyMenuItem(JPopupMenu menu) {
        JMenuItem mntmCopy = new JMenuItem(TmmResourceBundle.getString("menuitem.copy"));
        mntmCopy.addActionListener(e -> {
            if (menu.getInvoker() instanceof JTextComponent) {
                ((JTextComponent)menu.getInvoker()).copy();
            }
        });
        return mntmCopy;
    }

    private static JMenuItem getPasteMenuItem(JPopupMenu menu) {
        JMenuItem mntmPaste = new JMenuItem(TmmResourceBundle.getString("menuitem.paste"));
        mntmPaste.addActionListener(e -> {
            if (menu.getInvoker() instanceof JTextComponent) {
                ((JTextComponent)menu.getInvoker()).paste();
            }
        });
        return mntmPaste;
    }

    public static JPopupMenu buildCutCopyPaste() {
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem mntmCut = TextFieldPopupMenu.getCutMenuItem(popupMenu);
        final JMenuItem mntmCopy = TextFieldPopupMenu.getCopyMenuItem(popupMenu);
        final JMenuItem mntmPaste = TextFieldPopupMenu.getPasteMenuItem(popupMenu);
        popupMenu.add(mntmCut);
        popupMenu.add(mntmCopy);
        popupMenu.add(mntmPaste);
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JTextComponent jtc = (JTextComponent)popupMenu.getInvoker();
                boolean enableCutCopy = jtc.getSelectionEnd() - jtc.getSelectionStart() > 0;
                boolean enablePaste = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null) != null;
                mntmCut.setEnabled(enableCutCopy);
                mntmCopy.setEnabled(enableCutCopy);
                mntmPaste.setEnabled(enablePaste);
            }
        });
        return popupMenu;
    }
}

