/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTvShowMetadataProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;

public class TmdbTvShowArtworkProvider
extends TmdbMetadataProvider
implements ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowArtworkProvider.class);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        String imdbId;
        LOGGER.debug("getArtwork(): {}", (Object)options);
        this.initAPI();
        if (options.getMediaType() != MediaType.TV_SHOW && options.getMediaType() != MediaType.TV_EPISODE) {
            return Collections.emptyList();
        }
        if (options.getMediaType() == MediaType.TV_EPISODE) {
            try {
                TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
                episodeSearchAndScrapeOptions.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    episodeSearchAndScrapeOptions.setTvShowIds(tvShowIds);
                }
                MediaMetadata md = new TmdbTvShowMetadataProvider().getMetadata(episodeSearchAndScrapeOptions);
                return md.getMediaArt();
            }
            catch (MissingIdException | NothingFoundException e) {
                return Collections.emptyList();
            }
            catch (ScrapeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScrapeException(e);
            }
        }
        if (options.getTmdbId() == 0 && !MediaIdUtil.isValidImdbId(options.getImdbId()) && options.getIdAsInt("tvdb") > 0 && MediaIdUtil.isValidImdbId(imdbId = MediaIdUtil.getImdbIdFromTvdbId(options.getIdAsString("tvdb")))) {
            options.setImdbId(imdbId);
        }
        return new TmdbArtworkProvider(this.api, this.artworkBaseUrl).getArtwork(options);
    }
}

