/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.movieobject;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.movieobject.NavigationCommand;
import org.tinymediamanager.library.bluray.movieobject.TerminalInfo;

public class MovieObject {
    @XmlAttribute
    int mobjId;
    TerminalInfo terminalInfo = new TerminalInfo();
    NavigationCommand[] commands = new NavigationCommand[0];

    void setMovieObjectId(int n) {
        this.mobjId = n;
    }

    public TerminalInfo getTerminalInfo() {
        return this.terminalInfo;
    }

    public void setTerminalInfo(TerminalInfo terminalInfo) {
        this.terminalInfo = terminalInfo;
    }

    public NavigationCommand[] getNavigationCommands() {
        return this.commands;
    }

    public void setNavigationCommands(NavigationCommand[] navigationCommandArray) {
        this.commands = navigationCommandArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.terminalInfo.readObject(dataInputStream);
        int n = dataInputStream.readUnsignedShort();
        NavigationCommand[] navigationCommandArray = new NavigationCommand[n];
        for (int i = 0; i < n; ++i) {
            navigationCommandArray[i] = new NavigationCommand();
            navigationCommandArray[i].readObject(dataInputStream);
            navigationCommandArray[i].setNavigationCommandId(i);
        }
        this.setNavigationCommands(navigationCommandArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        this.terminalInfo.writeObject(dataOutputStream);
        NavigationCommand[] navigationCommandArray = this.getNavigationCommands();
        dataOutputStream.writeShort(navigationCommandArray.length);
        for (int i = 0; i < navigationCommandArray.length; ++i) {
            if (navigationCommandArray[i].command_id != i) {
                throw new IOException("NavigationCommand Id does not match the array order " + navigationCommandArray[i].command_id);
            }
            navigationCommandArray[i].writeObject(dataOutputStream);
        }
    }
}

