/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.util.ProgressObserver;

public class ProgressAggregator {
    protected ProgressObserver _target;
    protected long[] _sizes;
    protected int[] _progress;

    public ProgressAggregator(ProgressObserver target, long[] sizes) {
        this._target = target;
        this._sizes = sizes;
        this._progress = new int[sizes.length];
    }

    public ProgressObserver startElement(final int index) {
        return new ProgressObserver(){

            @Override
            public void progress(int percent) {
                ProgressAggregator.this._progress[index] = percent;
                ProgressAggregator.this.updateAggProgress();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAggProgress() {
        long totalSize = 0L;
        long currentSize = 0L;
        ProgressAggregator progressAggregator = this;
        synchronized (progressAggregator) {
            int ll = this._sizes.length;
            for (int ii = 0; ii < ll; ++ii) {
                long size = this._sizes[ii];
                totalSize += size;
                currentSize += (long)((int)((double)(size * (long)this._progress[ii]) / 100.0));
            }
        }
        this._target.progress((int)(100.0 * (double)currentSize / (double)totalSize));
    }

    protected static long sum(long[] sizes) {
        long totalSize = 0L;
        for (long size : sizes) {
            totalSize += size;
        }
        return totalSize;
    }
}

