/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.kodi.KodiMovieMetadataProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.MediaScraperComboBox;
import org.tinymediamanager.ui.components.combobox.ScraperMetadataConfigCheckComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieScrapeMetadataDialog
extends TmmDialog {
    private final JComboBox<MediaLanguages> cbLanguage;
    private final MediaScraperComboBox cbMetadataScraper;
    private final MediaScraperCheckComboBox cbArtworkScraper;
    private final MediaScraperCheckComboBox cbTrailerScraper;
    private final ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig> cbScraperConfig;
    private final JCheckBox chckbxDoNotOverwrite;
    private boolean startScrape = false;

    public MovieScrapeMetadataDialog(String title) {
        super(title, "updateMetadata");
        MediaScraper defaultScraper = MediaScraper.getMediaScraperById(MovieModuleManager.getInstance().getSettings().getMovieScraper(), ScraperType.MOVIE);
        ArrayList<MediaScraper> selectedArtworkScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper mediaScraper : MovieModuleManager.getInstance().getMovieList().getAvailableArtworkScrapers()) {
            if (!MovieModuleManager.getInstance().getSettings().getArtworkScrapers().contains(mediaScraper.getId())) continue;
            selectedArtworkScrapers.add(mediaScraper);
        }
        ArrayList<MediaScraper> selectedTrailerScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper trailerScraper : MovieModuleManager.getInstance().getMovieList().getAvailableTrailerScrapers()) {
            if (!MovieModuleManager.getInstance().getSettings().getTrailerScrapers().contains(trailerScraper.getId())) continue;
            selectedTrailerScrapers.add(trailerScraper);
        }
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][600lp:800lp,grow]", "[][][][][shrink 0][150lp:n, grow]"));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        jPanel.add((Component)lblLanguageT, "cell 0 0,alignx trailing");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        this.cbLanguage.setSelectedItem((Object)MovieModuleManager.getInstance().getSettings().getScraperLanguage());
        jPanel.add(this.cbLanguage, "cell 1 0,growx");
        TmmLabel lblMetadataScraperT = new TmmLabel(TmmResourceBundle.getString("scraper.metadata"));
        jPanel.add((Component)lblMetadataScraperT, "cell 0 1,alignx right");
        this.cbMetadataScraper = new MediaScraperComboBox(MovieModuleManager.getInstance().getMovieList().getAvailableMediaScrapers().stream().filter(scraper -> !(scraper.getMediaProvider() instanceof KodiMovieMetadataProvider)).collect(Collectors.toList()));
        jPanel.add((Component)this.cbMetadataScraper, "cell 1 1,growx");
        this.cbMetadataScraper.setSelectedItem(defaultScraper);
        TmmLabel lblArtworkScraper = new TmmLabel(TmmResourceBundle.getString("scraper.artwork"));
        jPanel.add((Component)lblArtworkScraper, "cell 0 2,alignx right");
        this.cbArtworkScraper = new MediaScraperCheckComboBox(MovieModuleManager.getInstance().getMovieList().getAvailableArtworkScrapers());
        jPanel.add((Component)this.cbArtworkScraper, "cell 1 2,growx");
        TmmLabel lblTrailerScraper = new TmmLabel(TmmResourceBundle.getString("scraper.trailer"));
        jPanel.add((Component)lblTrailerScraper, "cell 0 3,alignx right");
        this.cbTrailerScraper = new MediaScraperCheckComboBox(MovieModuleManager.getInstance().getMovieList().getAvailableTrailerScrapers());
        jPanel.add((Component)this.cbTrailerScraper, "cell 1 3,growx");
        JSeparator separator = new JSeparator();
        jPanel.add((Component)separator, "cell 0 4 2 1,growx");
        JPanel panelScraperConfig = new JPanel();
        jPanel.add((Component)panelScraperConfig, "cell 0 5 2 1,grow");
        panelScraperConfig.setLayout((LayoutManager)new MigLayout("", "[300lp:500lp,grow]", "[][][]"));
        TmmLabel lblScrapeFollowingItems = new TmmLabel(TmmResourceBundle.getString("scraper.metadata.select"));
        panelScraperConfig.add((Component)lblScrapeFollowingItems, "cell 0 0");
        this.cbScraperConfig = new ScraperMetadataConfigCheckComboBox<MovieScraperMetadataConfig>(MovieScraperMetadataConfig.getValuesWithout(MovieScraperMetadataConfig.ID));
        this.cbScraperConfig.enableFilter((movieScraperMetadataConfig, s) -> movieScraperMetadataConfig.getDescription().toLowerCase(Locale.ROOT).startsWith(s.toLowerCase(Locale.ROOT)));
        panelScraperConfig.add(this.cbScraperConfig, "cell 0 1 ,wmin 0,grow");
        this.chckbxDoNotOverwrite = new JHintCheckBox(TmmResourceBundle.getString("message.scrape.donotoverwrite"));
        this.chckbxDoNotOverwrite.setToolTipText(TmmResourceBundle.getString("message.scrape.donotoverwrite.desc"));
        panelScraperConfig.add((Component)this.chckbxDoNotOverwrite, "cell 0 2");
        JButton jButton = new JButton(TmmResourceBundle.getString("Button.cancel"));
        jButton.setIcon(IconManager.CANCEL_INV);
        jButton.addActionListener(e -> {
            this.startScrape = false;
            this.setVisible(false);
        });
        this.addButton(jButton);
        JButton btnStart = new JButton(TmmResourceBundle.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startScrape = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        if (!selectedArtworkScrapers.isEmpty()) {
            this.cbArtworkScraper.setSelectedItems(selectedArtworkScrapers);
        }
        if (!selectedTrailerScrapers.isEmpty()) {
            this.cbTrailerScraper.setSelectedItems(selectedTrailerScrapers);
        }
        List<MovieScraperMetadataConfig> list = MovieModuleManager.getInstance().getSettings().getScraperMetadataConfig();
        if (!MovieModuleManager.getInstance().getSettings().isScrapeBestImage()) {
            list.removeAll(MovieScraperMetadataConfig.valuesForType(ScraperMetadataConfig.Type.ARTWORK));
        }
        this.cbScraperConfig.setSelectedItems(list);
        this.chckbxDoNotOverwrite.setSelected(MovieModuleManager.getInstance().getSettings().isDoNotOverwriteExistingData());
    }

    public MovieSearchAndScrapeOptions getMovieSearchAndScrapeOptions() {
        MovieSearchAndScrapeOptions movieSearchAndScrapeConfig = new MovieSearchAndScrapeOptions();
        movieSearchAndScrapeConfig.setCertificationCountry(MovieModuleManager.getInstance().getSettings().getCertificationCountry());
        movieSearchAndScrapeConfig.setReleaseDateCountry(MovieModuleManager.getInstance().getSettings().getReleaseDateCountry());
        movieSearchAndScrapeConfig.setLanguage((MediaLanguages)((Object)this.cbLanguage.getSelectedItem()));
        movieSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        movieSearchAndScrapeConfig.setArtworkScraper(this.cbArtworkScraper.getSelectedItems());
        movieSearchAndScrapeConfig.setTrailerScraper(this.cbTrailerScraper.getSelectedItems());
        return movieSearchAndScrapeConfig;
    }

    public List<MovieScraperMetadataConfig> getMovieScraperMetadataConfig() {
        return this.cbScraperConfig.getSelectedItems();
    }

    public boolean getOverwriteExistingItems() {
        return !this.chckbxDoNotOverwrite.isSelected();
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

