/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.logging.ThresholdLoggerFilter;

public class TmmLoggingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmLoggingUtils.class);

    private TmmLoggingUtils() {
        throw new IllegalAccessError();
    }

    public static Level getLoggingLevel(String level) {
        if (StringUtils.isBlank((CharSequence)level)) {
            return null;
        }
        return switch (level.toUpperCase(Locale.ROOT).strip()) {
            case "OFF", "NONE" -> Level.OFF;
            case "ERROR" -> Level.ERROR;
            case "WARN" -> Level.WARN;
            case "INFO" -> Level.INFO;
            case "DEBUG" -> Level.DEBUG;
            case "TRACE" -> Level.TRACE;
            default -> throw new IllegalArgumentException("Unknown log level: " + level);
        };
    }

    public static void stopStartupAppender() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender appender = lc.getLogger("ROOT").getAppender("STARTUP");
        if (appender != null) {
            appender.stop();
        }
    }

    public static void setConsoleLogLevel() {
        try {
            Level level = TmmLoggingUtils.getLoggingLevel(System.getProperty("tmm.consoleloglevel", ""));
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            Appender consoleAppender = lc.getLogger("ROOT").getAppender("CONSOLE");
            if (consoleAppender instanceof ConsoleAppender) {
                if (level == null) {
                    consoleAppender.stop();
                } else {
                    ThresholdLoggerFilter filter = new ThresholdLoggerFilter(level);
                    filter.start();
                    consoleAppender.clearAllFilters();
                    consoleAppender.addFilter((Filter)filter);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not set console log level: {}", (Object)e.getMessage());
        }
    }

    public static void setLogLevel(String loggerName, String jvmParam) {
        String levelStr = System.getProperty(jvmParam);
        if (StringUtils.isBlank((CharSequence)levelStr)) {
            return;
        }
        try {
            LoggerContext ctx = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger logger = ctx.getLogger(loggerName);
            logger.setLevel(Level.DEBUG);
        }
        catch (Exception e) {
            LOGGER.error("Could not set log level for {}: {}", (Object)loggerName, (Object)e.getMessage());
        }
    }
}

