/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.Base64;

public class JsonApiRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiRequest.class);
    private static final String TAG = JsonApiRequest.class.getSimpleName();
    private static final int REQUEST_TIMEOUT = 30000;
    private static final ObjectMapper OM = new ObjectMapper();

    public static ObjectNode execute(HostConfig hostConfig, ObjectNode objectNode) throws ApiException {
        String string = JsonApiRequest.postRequest(hostConfig, objectNode.toString());
        LOGGER.debug("Response: {}", (Object)string);
        return JsonApiRequest.parseResponse(string);
    }

    private static String postRequest(HostConfig hostConfig, String string) throws ApiException {
        try {
            Object object;
            URL uRL = new URL("http", hostConfig.getAddress(), hostConfig.getHttpPort(), "/jsonrpc");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            if (hostConfig.getUsername() != null && !hostConfig.getUsername().isEmpty() && hostConfig.getPassword() != null && !hostConfig.getPassword().isEmpty()) {
                object = Base64.encodeToString((hostConfig.getUsername() + ":" + hostConfig.getPassword()).getBytes(), false);
                httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
            }
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setRequestProperty("User-Agent", JsonApiRequest.buildUserAgent());
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(30000);
            httpURLConnection.setDoOutput(true);
            LOGGER.debug("Request: {}", (Object)string.toString());
            try {
                object = new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8");
                ((Writer)object).write(string);
                ((OutputStreamWriter)object).close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ApiException(9, "Unable to convert request to UTF-8", unsupportedEncodingException);
            }
            object = new StringBuilder();
            BufferedReader bufferedReader = null;
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                try {
                    String string2;
                    bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"), 8192);
                    while ((string2 = bufferedReader.readLine()) != null) {
                        ((StringBuilder)object).append(string2);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ApiException(9, "Unable to convert HTTP response to UTF-8", unsupportedEncodingException);
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                return ((StringBuilder)object).toString();
            }
            switch (n) {
                case 400: {
                    throw new ApiException(19, "Server says \"400 Bad HTTP request\".");
                }
                case 401: {
                    throw new ApiException(20, "Server says \"401 Unauthorized\".");
                }
                case 403: {
                    throw new ApiException(21, "Server says \"403 Forbidden\".");
                }
                case 404: {
                    throw new ApiException(22, "Server says \"404 Not Found\".");
                }
            }
            if (n >= 100 && n < 200) {
                throw new ApiException(14, "Server returned informational code " + n + " instead of 200.");
            }
            if (n >= 200 && n < 300) {
                throw new ApiException(15, "Server returned success code " + n + " instead of 200.");
            }
            if (n >= 300 && n < 400) {
                throw new ApiException(16, "Server returned redirection code " + n + " instead of 200.");
            }
            if (n >= 400 && n < 500) {
                throw new ApiException(17, "Server returned client error " + n + ".");
            }
            if (n >= 500 && n < 600) {
                throw new ApiException(18, "Server returned server error " + n + ".");
            }
            throw new ApiException(13, "Server returned unspecified code " + n + ".");
        }
        catch (MalformedURLException malformedURLException) {
            throw new ApiException(1, malformedURLException.getMessage(), malformedURLException);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ApiException(6, socketTimeoutException.getMessage(), socketTimeoutException);
        }
        catch (ConnectException connectException) {
            throw new ApiException(5, connectException.getMessage(), connectException);
        }
        catch (IOException iOException) {
            throw new ApiException(2, iOException.getMessage(), iOException);
        }
    }

    private static ObjectNode parseResponse(String string) throws ApiException {
        try {
            ObjectNode objectNode = (ObjectNode)OM.readTree(string.toString());
            if (objectNode.has("error")) {
                if (objectNode.get("error").isTextual()) {
                    TextNode textNode = (TextNode)objectNode.get("error");
                    throw new ApiException(12, "Error: " + textNode.asText(), null);
                }
                ObjectNode objectNode2 = (ObjectNode)objectNode.get("error");
                throw new ApiException(12, "Error " + objectNode2.get("code").asInt() + ": " + objectNode2.get("message").asText(), null);
            }
            if (!objectNode.has("result")) {
                throw new ApiException(11, "Neither result nor error object found in response.", null);
            }
            if (objectNode.get("result").isNull()) {
                return null;
            }
            return objectNode;
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new ApiException(10, "Parse error: " + jsonProcessingException.getMessage(), jsonProcessingException);
        }
    }

    private static String buildUserAgent() {
        return "tinyMediaManager-jsonrpclib-kodi";
    }
}

