/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.PartitionHeader;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class PartitionDescriptor
extends UDFDescriptor {
    public Long volumeDescriptorSeq;
    public Integer flags;
    public Integer partitionNumber;
    public RegId contents;
    public PartitionHeader contentsUse;
    public Long accessType;
    public Long startingLocation;
    public Long length;
    public RegId implIdentifier;
    public byte[] implUse;
    public static final int LENGTH = 512;

    public PartitionDescriptor() {
    }

    public PartitionDescriptor(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 5;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 512) {
            throw new InvalidDescriptor("Partition descriptor too short");
        }
        this.deserializeTag(byArray);
        this.volumeDescriptorSeq = this.getUInt32(byArray);
        this.flags = this.getUInt16(byArray);
        this.partitionNumber = this.getUInt16(byArray);
        this.contents = new RegId(this.getBytes(byArray, 32));
        this.contentsUse = new PartitionHeader(this.getBytes(byArray, 128));
        this.accessType = this.getUInt32(byArray);
        this.startingLocation = this.getUInt32(byArray);
        this.length = this.getUInt32(byArray);
        this.implIdentifier = new RegId(this.getBytes(byArray, 32));
        this.implUse = this.getBytes(byArray, 128);
        this.currentPos = 512;
    }
}

