/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.CharSpec;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.Timestamp;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class FileSetDescriptor
extends UDFDescriptor {
    public Timestamp recordDateTime;
    public Integer interchangeLevel;
    public Integer maxInterchangeLevel;
    public Long charsetList;
    public Long maxCharsetList;
    public Long fileSetNum;
    public Long fileSetDescriptorNum;
    public CharSpec lvIdentifierCharset;
    public DString lvIdentifier;
    public CharSpec fileSetCharset;
    public DString fileSetIdentifier;
    public DString copyrightFileId;
    public DString abstractFileId;
    public LongAD rootICB;
    public RegId domainIdentifier;
    public LongAD nextExtent;
    public LongAD sysStreamDirICB;
    public static final int LENGTH = 512;

    public FileSetDescriptor() {
    }

    public FileSetDescriptor(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 256;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 512) {
            throw new InvalidDescriptor("File set descriptor too short");
        }
        this.deserializeTag(byArray);
        this.recordDateTime = new Timestamp(this.getBytes(byArray, 12));
        this.interchangeLevel = this.getUInt16(byArray);
        this.maxInterchangeLevel = this.getUInt16(byArray);
        this.charsetList = this.getUInt32(byArray);
        this.maxCharsetList = this.getUInt32(byArray);
        this.fileSetNum = this.getUInt32(byArray);
        this.fileSetDescriptorNum = this.getUInt32(byArray);
        this.lvIdentifierCharset = new CharSpec(this.getBytes(byArray, 64));
        this.lvIdentifier = new DString(this.getBytes(byArray, 128));
        this.fileSetCharset = new CharSpec(this.getBytes(byArray, 64));
        this.fileSetIdentifier = new DString(this.getBytes(byArray, 32));
        this.copyrightFileId = new DString(this.getBytes(byArray, 32));
        this.abstractFileId = new DString(this.getBytes(byArray, 32));
        this.rootICB = new LongAD(this.getBytes(byArray, 16));
        this.domainIdentifier = new RegId(this.getBytes(byArray, 32));
        this.nextExtent = new LongAD(this.getBytes(byArray, 16));
        this.sysStreamDirICB = new LongAD(this.getBytes(byArray, 16));
        this.currentPos = 512;
    }
}

