/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractTextMovieUIFilter;

public class MovieTmdbIdFilter
extends AbstractTextMovieUIFilter {
    @Override
    public String getId() {
        return "movieTmdbIdFilter";
    }

    @Override
    public boolean accept(Movie movie) {
        String tmbdId = Integer.toString(movie.getTmdbId());
        if (StringUtils.isEmpty((CharSequence)this.normalizedFilterText) && tmbdId.equals("0")) {
            return true;
        }
        try {
            if (!tmbdId.equals("0") && StringUtils.isNotEmpty((CharSequence)this.normalizedFilterText)) {
                Matcher matcher = this.filterPattern.matcher(StrgUtils.normalizeString(tmbdId));
                return matcher.find();
            }
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.tmdb"));
    }
}

