/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ARDetectorTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;

public class MovieARDetectorTask
extends ARDetectorTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieARDetectorTask.class);
    private final List<Movie> movies;

    public MovieARDetectorTask(List<Movie> movies) {
        super(TmmTaskHandle.TaskType.MAIN_TASK);
        this.movies = movies;
    }

    @Override
    protected void doInBackground() {
        if (!this.canRun()) {
            return;
        }
        LOGGER.info("Detecting aspect ratio for {} movies", (Object)this.movies.size());
        int filesTotal = this.movies.stream().map(movie -> movie.getMediaFiles(MediaFileType.VIDEO).size()).reduce(Integer::sum).orElse(0);
        if (filesTotal > 0) {
            this.setWorkUnits(filesTotal * 100);
        }
        int idx = 0;
        for (Movie movie2 : this.movies) {
            for (MediaFile mediaFile : movie2.getMediaFiles(MediaFileType.VIDEO)) {
                if (this.cancel) break;
                this.analyze(mediaFile, idx++);
            }
            if (this.cancel) {
                LOGGER.debug("Abort queue");
                break;
            }
            movie2.saveToDb();
            movie2.writeNFO();
        }
        LOGGER.info("Finished detecting aspect ratio - took {} ms", (Object)this.getRuntime());
    }
}

