/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.dbmigrator.mvstore;

import org.tinymediamanager.dbmigrator.mvstore.Page;

public class CursorPos {
    public Page page;
    public int index;
    public CursorPos parent;

    public CursorPos(Page page, int n, CursorPos cursorPos) {
        this.page = page;
        this.index = n;
        this.parent = cursorPos;
    }

    public static CursorPos traverseDown(Page page, Object object) {
        CursorPos cursorPos = null;
        while (!page.isLeaf()) {
            int n = page.binarySearch(object) + 1;
            if (n < 0) {
                n = -n;
            }
            cursorPos = new CursorPos(page, n, cursorPos);
            page = page.getChildPage(n);
        }
        return new CursorPos(page, page.binarySearch(object), cursorPos);
    }

    int processRemovalInfo(long l) {
        int n = 0;
        CursorPos cursorPos = this;
        while (cursorPos != null) {
            n += cursorPos.page.removePage(l);
            cursorPos = cursorPos.parent;
        }
        return n;
    }

    public String toString() {
        return "CursorPos{page=" + this.page + ", index=" + this.index + ", parent=" + this.parent + '}';
    }
}

