/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieToggleWatchedFlagAction
extends TmmAction {
    public MovieToggleWatchedFlagAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.togglewatchedflag"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() + 64));
    }

    @Override
    protected void processAction(ActionEvent e) {
        List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies();
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        for (Movie movie : selectedMovies) {
            if (!movie.isWatched()) {
                movie.setWatched(true);
                movie.setPlaycount(1);
                movie.setLastWatched(new Date());
            } else {
                movie.setWatched(false);
                movie.setPlaycount(0);
                movie.setLastWatched(null);
            }
            movie.writeNFO();
            movie.saveToDb();
        }
        MainWindow.getInstance().setCursor(Cursor.getPredefinedCursor(0));
    }
}

