/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.ttml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mp4parser.boxes.iso14496.part12.SubSampleInformationBox;
import org.mp4parser.boxes.iso14496.part30.XMLSubtitleSampleEntry;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.tracks.ttml.TtmlHelpers;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TtmlTrackImpl
extends AbstractTrack {
    TrackMetaData trackMetaData = new TrackMetaData();
    XMLSubtitleSampleEntry xmlSubtitleSampleEntry = new XMLSubtitleSampleEntry();
    List<Sample> samples = new ArrayList<Sample>();
    SubSampleInformationBox subSampleInformationBox = new SubSampleInformationBox();
    private long[] sampleDurations;

    public TtmlTrackImpl(String name, List<Document> ttmls) throws IOException, ParserConfigurationException, SAXException, XPathExpressionException, URISyntaxException {
        super(name);
        this.extractLanguage(ttmls);
        HashSet<String> mimeTypes = new HashSet<String>();
        this.sampleDurations = new long[ttmls.size()];
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        for (int sampleNo = 0; sampleNo < ttmls.size(); ++sampleNo) {
            Document ttml = ttmls.get(sampleNo);
            SubSampleInformationBox.SubSampleEntry subSampleEntry = new SubSampleInformationBox.SubSampleEntry();
            this.subSampleInformationBox.getEntries().add(subSampleEntry);
            subSampleEntry.setSampleDelta(1L);
            this.sampleDurations[sampleNo] = this.extractDuration(ttml);
            List<byte[]> images = TtmlTrackImpl.extractImages(ttml);
            mimeTypes.addAll(this.extractMimeTypes(ttml));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TtmlHelpers.pretty(ttml, baos, 4);
            SubSampleInformationBox.SubSampleEntry.SubsampleEntry xmlEntry = new SubSampleInformationBox.SubSampleEntry.SubsampleEntry();
            xmlEntry.setSubsampleSize((long)baos.size());
            subSampleEntry.getSubsampleEntries().add(xmlEntry);
            for (byte[] image : images) {
                baos.write(image);
                SubSampleInformationBox.SubSampleEntry.SubsampleEntry imageEntry = new SubSampleInformationBox.SubSampleEntry.SubsampleEntry();
                imageEntry.setSubsampleSize((long)image.length);
                subSampleEntry.getSubsampleEntries().add(imageEntry);
            }
            final byte[] finalSample = baos.toByteArray();
            this.samples.add(new Sample(){

                @Override
                public void writeTo(WritableByteChannel channel) throws IOException {
                    channel.write(ByteBuffer.wrap(finalSample));
                }

                @Override
                public long getSize() {
                    return finalSample.length;
                }

                @Override
                public ByteBuffer asByteBuffer() {
                    return ByteBuffer.wrap(finalSample);
                }

                @Override
                public SampleEntry getSampleEntry() {
                    return TtmlTrackImpl.this.xmlSubtitleSampleEntry;
                }
            });
        }
        this.xmlSubtitleSampleEntry.setNamespace(TtmlTrackImpl.join(",", TtmlHelpers.getAllNamespaces(ttmls.get(0))));
        this.xmlSubtitleSampleEntry.setSchemaLocation("");
        this.xmlSubtitleSampleEntry.setAuxiliaryMimeTypes(TtmlTrackImpl.join(",", new ArrayList(mimeTypes).toArray(new String[mimeTypes.size()])));
        this.trackMetaData.setTimescale(30000L);
        this.trackMetaData.setLayer(65535);
    }

    public static String getLanguage(Document document) {
        return document.getDocumentElement().getAttribute("xml:lang");
    }

    protected static List<byte[]> extractImages(Document ttml) throws XPathExpressionException, URISyntaxException, IOException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("//*/@backgroundImage");
        NodeList nl = (NodeList)expr.evaluate(ttml, XPathConstants.NODESET);
        LinkedHashMap<String, String> internalNames2Original = new LinkedHashMap<String, String>();
        int p = 1;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node bgImageNode = nl.item(i);
            String uri = bgImageNode.getNodeValue();
            String ext = uri.substring(uri.lastIndexOf("."));
            String internalName = (String)internalNames2Original.get(uri);
            if (internalName == null) {
                internalName = "urn:mp4parser:" + p++ + ext;
                internalNames2Original.put(internalName, uri);
            }
            bgImageNode.setNodeValue(internalName);
        }
        ArrayList<byte[]> images = new ArrayList<byte[]>();
        if (!internalNames2Original.isEmpty()) {
            for (Map.Entry internalName2Original : internalNames2Original.entrySet()) {
                URI pic = new URI(ttml.getDocumentURI()).resolve((String)internalName2Original.getValue());
                images.add(TtmlTrackImpl.streamToByteArray(pic.toURL().openStream()));
            }
        }
        return images;
    }

    private static String join(String joiner, String[] i) {
        StringBuilder result = new StringBuilder();
        for (String s : i) {
            result.append(s).append(joiner);
        }
        result.setLength(result.length() > 0 ? result.length() - 1 : 0);
        return result.toString();
    }

    private static long latestTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        try {
            XPathExpression xp = xpath.compile("//*[name()='p']");
            NodeList timedNodes = (NodeList)xp.evaluate(document, XPathConstants.NODESET);
            long lastTimeStamp = 0L;
            for (int i = 0; i < timedNodes.getLength(); ++i) {
                lastTimeStamp = Math.max(TtmlHelpers.getEndTime(timedNodes.item(i)), lastTimeStamp);
            }
            return lastTimeStamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] streamToByteArray(InputStream input) throws IOException {
        byte[] buffer = new byte[8096];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    protected long firstTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        try {
            XPathExpression xp = xpath.compile("//*[@begin]");
            NodeList timedNodes = (NodeList)xp.evaluate(document, XPathConstants.NODESET);
            long firstTimestamp = Long.MAX_VALUE;
            for (int i = 0; i < timedNodes.getLength(); ++i) {
                firstTimestamp = Math.min(TtmlHelpers.getStartTime(timedNodes.item(i)), firstTimestamp);
            }
            return firstTimestamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected long lastTimestamp(Document document) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(TtmlHelpers.NAMESPACE_CONTEXT);
        try {
            XPathExpression xp = xpath.compile("//*[@end]");
            NodeList timedNodes = (NodeList)xp.evaluate(document, XPathConstants.NODESET);
            long lastTimeStamp = 0L;
            for (int i = 0; i < timedNodes.getLength(); ++i) {
                lastTimeStamp = Math.max(TtmlHelpers.getEndTime(timedNodes.item(i)), lastTimeStamp);
            }
            return lastTimeStamp;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void extractLanguage(List<Document> ttmls) {
        String firstLang = null;
        for (Document ttml : ttmls) {
            String lang = TtmlTrackImpl.getLanguage(ttml);
            if (firstLang == null) {
                firstLang = lang;
                this.trackMetaData.setLanguage(Locale.forLanguageTag(lang).getISO3Language());
                continue;
            }
            if (firstLang.equals(lang)) continue;
            throw new RuntimeException("Within one Track all sample documents need to have the same language");
        }
    }

    protected List<String> extractMimeTypes(Document ttml) throws XPathExpressionException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("//*/@smpte:backgroundImage");
        NodeList nl = (NodeList)expr.evaluate(ttml, XPathConstants.NODESET);
        LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>();
        boolean p = true;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node bgImageNode = nl.item(i);
            String uri = bgImageNode.getNodeValue();
            String ext = uri.substring(uri.lastIndexOf("."));
            if (ext.contains("jpg") || ext.contains("jpeg")) {
                mimeTypes.add("image/jpeg");
                continue;
            }
            if (!ext.contains("png")) continue;
            mimeTypes.add("image/png");
        }
        return new ArrayList<String>(mimeTypes);
    }

    long extractDuration(Document ttml) {
        return this.lastTimestamp(ttml) - this.firstTimestamp(ttml);
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.xmlSubtitleSampleEntry);
    }

    @Override
    public long[] getSampleDurations() {
        long[] adoptedSampleDuration = new long[this.sampleDurations.length];
        for (int i = 0; i < adoptedSampleDuration.length; ++i) {
            adoptedSampleDuration[i] = this.sampleDurations[i] * this.trackMetaData.getTimescale() / 1000L;
        }
        return adoptedSampleDuration;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "subt";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.subSampleInformationBox;
    }

    @Override
    public void close() throws IOException {
    }
}

