/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MovieKeyArtSizeFilter
extends AbstractNumberMovieFilter {
    public MovieKeyArtSizeFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "####0 px"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "####0 px"));
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("filter.keyart.height"));
    }

    @Override
    public String getId() {
        return "movieKeyArtSize";
    }

    @Override
    public boolean accept(Movie movie) {
        return this.matchInt(movie.getArtworkDimension((MediaFileType)MediaFileType.KEYART).height);
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99999, 1);
    }
}

