/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRebuildImageCacheAction
extends TmmAction {
    public MovieRebuildImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("movie.rebuildimagecache"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("movie.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Settings.getInstance().isImageCache()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.imagecache.notactivated"));
            return;
        }
        final List<Movie> selectedMovies = MovieUIModule.getInstance().getSelectionModel().getSelectedMovies(true);
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        TmmTask task = new TmmTask(TmmResourceBundle.getString("tmm.rebuildimagecache"), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                HashSet<MediaFile> imageFiles = new HashSet<MediaFile>();
                for (Movie movie : selectedMovies) {
                    imageFiles.addAll(movie.getImagesToCache());
                }
                ImageCache.clearImageCache(imageFiles);
                imageFiles.forEach(ImageCache::cacheImageAsync);
            }
        };
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

