/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.converter;

import java.net.URI;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jdesktop.beansbinding.Converter;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public class CertificationImageConverter
extends Converter<MediaCertification, Icon> {
    public Icon convertForward(MediaCertification cert) {
        if (cert == null || cert == MediaCertification.UNKNOWN) {
            return null;
        }
        try {
            URI uri = ((Object)((Object)this)).getClass().getResource("/org/tinymediamanager/ui/images/certification/" + cert.name().toLowerCase(Locale.ROOT) + ".svg").toURI();
            TmmSvgIcon icon = new TmmSvgIcon(uri);
            icon.setPreferredHeight(32);
            icon.setAutosize(4);
            if (cert.getCountry() == CountryCode.US) {
                icon.setColor(UIManager.getColor("Label.foreground"), "#000000");
            }
            return icon;
        }
        catch (Exception e) {
            return null;
        }
    }

    public MediaCertification convertReverse(Icon arg0) {
        return null;
    }
}

