/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaStreamInfo;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.MediaFileSubtitleEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public abstract class MediaFileSubtitleEditTable
extends TmmEditorTable {
    private final EventList<MediaFileSubtitle> subtitleEventList;

    public MediaFileSubtitleEditTable(EventList<MediaFileSubtitle> subtitleEventList) {
        this.subtitleEventList = subtitleEventList;
        this.setModel((TableModel)((Object)new TmmTableModel<MediaFileSubtitle>((EventList<MediaFileSubtitle>)GlazedListsSwing.swingThreadProxyList(subtitleEventList), new SubtitleTableFormat())));
        this.adjustColumnPreferredWidths(3);
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        MediaFileSubtitle subtitle = this.getSubtitle(row);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("subtitle.edit"));
        popupPanel.setOnCloseHandler(this::onEditSubtitle);
        MediaFileSubtitleEditorPanel subtitleEditorPanel = new MediaFileSubtitleEditorPanel(subtitle);
        popupPanel.setContent(subtitleEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    public abstract void onEditSubtitle();

    private MediaFileSubtitle getSubtitle(int row) {
        int index = this.convertRowIndexToModel(row);
        return (MediaFileSubtitle)this.subtitleEventList.get(index);
    }

    public List<MediaFileSubtitle> getSubtitleStreams() {
        ArrayList<MediaFileSubtitle> subtitles = new ArrayList<MediaFileSubtitle>();
        for (int i : this.getSelectedRows()) {
            MediaFileSubtitle subtitleStream = this.getSubtitle(i);
            if (subtitleStream == null) continue;
            subtitles.add(subtitleStream);
        }
        return subtitles;
    }

    public void addSubtitle() {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        MediaFileSubtitle subtitle = new MediaFileSubtitle();
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("subtitle.add"));
        popupPanel.setOnCloseHandler(() -> {
            this.subtitleEventList.add((Object)subtitle);
            this.onAddSubtitle();
        });
        MediaFileSubtitleEditorPanel subtitleEditorPanel = new MediaFileSubtitleEditorPanel(subtitle);
        popupPanel.setContent(subtitleEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    public abstract void onAddSubtitle();

    private static class SubtitleTableFormat
    extends TmmTableFormat<MediaFileSubtitle> {
        private SubtitleTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.language"), "language", MediaStreamInfo::getLanguage, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.default"), "default", MediaStreamInfo::isDefaultStream, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.forced"), "forced", MediaStreamInfo::isForced, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.sdh"), "sdh", MediaStreamInfo::isSdh, Boolean.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.format"), "format", MediaStreamInfo::getCodec, String.class);
            col.setColumnResizeable(false);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("metatag.title"), "title", MediaStreamInfo::getTitle, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }
}

