/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.model.message.Connection;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.HttpExchangeUpnpStream;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamServer;
import org.jupnp.transport.spi.UpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.thirdparty.upnp.MimeTypes;
import org.tinymediamanager.thirdparty.upnp.StreamServerConfigurationImpl;

public class TmmStreamServerImpl
implements StreamServer<StreamServerConfigurationImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmStreamServerImpl.class);
    protected final StreamServerConfigurationImpl configuration;
    protected final ExecutorService executorService;
    protected HttpServer server;

    public TmmStreamServerImpl(StreamServerConfigurationImpl configuration, ExecutorService executorService) {
        this.configuration = configuration;
        this.executorService = executorService;
    }

    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(bindAddress, this.configuration.getListenPort());
            this.server = HttpServer.create(socketAddress, this.configuration.getTcpConnectionBacklog());
            this.server.setExecutor(this.executorService);
            this.server.createContext("/upnp/movies", new VideoHttpHandler());
            this.server.createContext("/upnp/tvshows", new VideoHttpHandler());
            this.server.createContext("/", new RequestHttpHandler(router));
            LOGGER.info("Created server (for receiving TCP streams) on: {}", (Object)this.server.getAddress());
        }
        catch (Exception ex) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName() + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public synchronized int getPort() {
        return this.server.getAddress().getPort();
    }

    public StreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    public synchronized void run() {
        LOGGER.info("Starting StreamServer...");
        this.server.start();
    }

    public synchronized void stop() {
        LOGGER.info("Stopping StreamServer...");
        if (this.server != null) {
            this.server.stop(1);
        }
    }

    private String getFirstHeader(Map<String, List<String>> headers, String name) {
        List<String> values = headers.get(name);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    protected boolean isConnectionOpen(HttpExchange exchange) {
        LOGGER.warn("Can't check client connection, socket access impossible on JDK webserver!");
        return true;
    }

    protected class VideoHttpHandler
    implements HttpHandler {
        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            LOGGER.trace("Received HTTP exchange: {} {}", (Object)httpExchange.getRequestMethod(), (Object)httpExchange.getRequestURI());
            new Thread(() -> {
                String uri = httpExchange.getRequestURI().toString();
                LOGGER.debug("Incoming: {} {} {}", new Object[]{httpExchange.getRemoteAddress(), httpExchange.getRequestMethod(), uri});
                if (uri.startsWith("/upnp")) {
                    String[] path = StringUtils.split((String)uri, (char)'/');
                    if (path.length > 3) {
                        try {
                            UUID uuid = UUID.fromString(path[2]);
                            MediaEntity m = null;
                            if ("movies".equals(path[1])) {
                                m = MovieModuleManager.getInstance().getMovieList().lookupMovie(uuid);
                            } else if ("tvshows".equals(path[1])) {
                                m = TvShowModuleManager.getInstance().getTvShowList().lookupTvShow(uuid);
                            }
                            if (m != null) {
                                MediaFile mf = new MediaFile();
                                mf.setPath(m.getPathNIO().toString());
                                String fname = URLDecoder.decode(uri.substring(uri.indexOf(path[2]) + path[2].length() + 1), StandardCharsets.UTF_8);
                                String sanitized = FilenameUtils.normalize((String)fname);
                                if (sanitized != null) {
                                    mf.setFilename(sanitized);
                                    this.serveMediaFile(mf, httpExchange);
                                }
                            }
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.debug("Seems not to be a valid MediaEntity", (Throwable)e);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error serving media file", (Throwable)e);
                        }
                    }
                } else {
                    LOGGER.debug("WebServer does not know what to do with this request");
                }
            }).start();
        }

        private void serveMediaFile(MediaFile file, HttpExchange exchange) throws IOException {
            boolean ifNoneMatchMatches;
            LOGGER.info("Serving: {}", (Object)file.getFileAsPath());
            String method = exchange.getRequestMethod();
            Headers headers = exchange.getRequestHeaders();
            String mime = MimeTypes.getMimeTypeAsString(file.getExtension());
            Path path = file.getFileAsPath();
            long fileLen = Files.size(path);
            String etag = Integer.toHexString((path.toString() + Files.getLastModifiedTime(path, new LinkOption[0]) + fileLen).hashCode());
            long startFrom = 0L;
            long endAt = fileLen - 1L;
            boolean isPartial = false;
            String range = this.getFirstHeader(headers, "Range");
            if (range != null && range.startsWith("bytes=")) {
                String[] parts = range.substring(6).split("-");
                try {
                    startFrom = Long.parseLong(parts[0]);
                    if (parts.length > 1 && !parts[1].isEmpty()) {
                        endAt = Long.parseLong(parts[1]);
                    }
                    if (startFrom <= endAt && endAt < fileLen) {
                        isPartial = true;
                    }
                }
                catch (NumberFormatException ignored) {
                    LOGGER.trace("Invalid Range header: {}", (Object)range);
                }
            }
            String ifRange = this.getFirstHeader(headers, "If-Range");
            String ifNoneMatch = this.getFirstHeader(headers, "If-None-Match");
            boolean ifRangeMatches = ifRange == null || ifRange.equals(etag);
            boolean bl = ifNoneMatchMatches = ifNoneMatch != null && (ifNoneMatch.equals("*") || ifNoneMatch.equals(etag));
            if (range == null && ifNoneMatchMatches || !ifRangeMatches && ifNoneMatchMatches) {
                this.sendResponse(exchange, 304, mime, null, 0L, etag, false);
                return;
            }
            if (range != null && startFrom >= fileLen) {
                exchange.getResponseHeaders().add("Content-Range", "bytes */" + fileLen);
                this.sendResponse(exchange, 416, "text/plain", null, 0L, etag, false);
                return;
            }
            if ("HEAD".equalsIgnoreCase(method)) {
                long contentLength;
                int status = isPartial ? 206 : 200;
                long l = contentLength = isPartial ? endAt - startFrom + 1L : fileLen;
                if (isPartial) {
                    exchange.getResponseHeaders().add("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                }
                this.sendResponse(exchange, status, mime, null, contentLength, etag, true);
                return;
            }
            try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
                raf.seek(startFrom);
                long contentLength = endAt - startFrom + 1L;
                if (isPartial) {
                    exchange.getResponseHeaders().add("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                    this.sendResponse(exchange, 206, mime, raf, contentLength, etag, false);
                } else {
                    this.sendResponse(exchange, 200, mime, raf, fileLen, etag, false);
                }
            }
            catch (IOException e) {
                LOGGER.debug("(UPnP) Error serving file: {}", (Object)e.getMessage());
                try {
                    exchange.close();
                }
                catch (Exception ex) {
                    LOGGER.trace("Error closing exchange after IO failure", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendResponse(HttpExchange exchange, int status, String mime, RandomAccessFile raf, long contentLength, String etag, boolean headOnly) {
            block55: {
                try {
                    OutputStream os;
                    if (etag != null) {
                        exchange.getResponseHeaders().add("ETag", etag);
                    }
                    exchange.getResponseHeaders().add("Content-Type", mime);
                    exchange.getResponseHeaders().add("Accept-Ranges", "bytes");
                    if (!headOnly) {
                        try {
                            exchange.sendResponseHeaders(status, contentLength);
                        }
                        catch (IOException e) {
                            LOGGER.debug("(UPnP) Failed to send response headers: {}", (Object)e.getMessage());
                            try {
                                exchange.close();
                            }
                            catch (Exception ex) {
                                LOGGER.trace("Error closing exchange after header failure", (Throwable)ex);
                            }
                            try {
                                exchange.close();
                            }
                            catch (Exception ignored) {
                                LOGGER.trace("Error closing exchange in finally", (Throwable)ignored);
                            }
                            return;
                        }
                    }
                    try {
                        exchange.sendResponseHeaders(status, -1L);
                    }
                    catch (IOException e) {
                        LOGGER.debug("(UPnP) Failed to send response headers (HEAD): {}", (Object)e.getMessage());
                        try {
                            exchange.close();
                        }
                        catch (Exception ex) {
                            LOGGER.trace("Error closing exchange after HEAD header failure", (Throwable)ex);
                        }
                        try {
                            exchange.close();
                        }
                        catch (Exception ignored) {
                            LOGGER.trace("Error closing exchange in finally", (Throwable)ignored);
                        }
                        return;
                    }
                    try {
                        exchange.close();
                    }
                    catch (Exception ex) {
                        LOGGER.trace("Error closing exchange after HEAD response", (Throwable)ex);
                    }
                    return;
                    if (raf != null) {
                        try {
                            os = exchange.getResponseBody();
                            try {
                                int read;
                                byte[] buffer = new byte[8192];
                                for (long remaining = contentLength; remaining > 0L && (read = raf.read(buffer, 0, (int)Math.min((long)buffer.length, remaining))) > 0; remaining -= (long)read) {
                                    os.write(buffer, 0, read);
                                }
                                os.flush();
                                break block55;
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (IOException e) {
                            LOGGER.debug("(UPnP) IO while writing response body: {}", (Object)e.getMessage());
                            break block55;
                        }
                        finally {
                            try {
                                raf.close();
                            }
                            catch (IOException ignored) {
                                LOGGER.trace("Error closing RandomAccessFile after response", (Throwable)ignored);
                            }
                        }
                    }
                    try {
                        os = exchange.getResponseBody();
                        try {
                            os.flush();
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        LOGGER.debug("(UPnP) IO while flushing/closing empty response: {}", (Object)e.getMessage());
                    }
                }
                finally {
                    try {
                        exchange.close();
                    }
                    catch (Exception ignored) {
                        LOGGER.trace("Error closing exchange in finally", (Throwable)ignored);
                    }
                }
            }
        }

        private String getFirstHeader(Map<String, List<String>> headers, String name) {
            List<String> values = headers.get(name);
            return values != null && !values.isEmpty() ? values.get(0) : null;
        }
    }

    protected class RequestHttpHandler
    implements HttpHandler {
        private final Router router;

        public RequestHttpHandler(Router router) {
            this.router = router;
        }

        @Override
        public void handle(final HttpExchange httpExchange) throws IOException {
            LOGGER.trace("Received HTTP exchange: {} {} {}", new Object[]{httpExchange.getRemoteAddress(), httpExchange.getRequestMethod(), httpExchange.getRequestURI()});
            this.router.received((UpnpStream)new HttpExchangeUpnpStream(this.router.getProtocolFactory(), httpExchange){

                protected Connection createConnection() {
                    return new HttpServerConnection(httpExchange);
                }
            });
        }
    }

    protected class HttpServerConnection
    implements Connection {
        protected HttpExchange exchange;

        public HttpServerConnection(HttpExchange exchange) {
            this.exchange = exchange;
        }

        public boolean isOpen() {
            return TmmStreamServerImpl.this.isConnectionOpen(this.exchange);
        }

        public InetAddress getRemoteAddress() {
            return this.exchange.getRemoteAddress() != null ? this.exchange.getRemoteAddress().getAddress() : null;
        }

        public InetAddress getLocalAddress() {
            return this.exchange.getLocalAddress() != null ? this.exchange.getLocalAddress().getAddress() : null;
        }
    }
}

